package net.minecraft.src;
// Decompiled by Jad v1.5.8g. Copyright 2001 Pavel Kouznetsov.
// Jad home page: http://www.kpdus.com/jad.html
// Decompiler options: packimports(3) braces deadcode 

import java.util.*;
import net.minecraft.client.Minecraft;
import net.minecraft.src.forge.*;

public class BlockColored extends BlockContainer
{

    public BlockColored(int i)
    {
        super(i, Material.rock);
    }

    public int colorMultiplier(IBlockAccess iblockaccess, int i, int j, int k)
    {
        TileEntityBlockColored tile = (TileEntityBlockColored)iblockaccess.getBlockTileEntity(i, j, k);
        if(tile == null)
        {
            return 0xff0000;
        }
        return tile.getRGB();
    }

    public int getBlockTexture(IBlockAccess iblockaccess, int i, int j, int k, int l)
    {
    	TileEntityBlockColored tile = (TileEntityBlockColored)mod_ColoredBlocks.mcInst.theWorld.getBlockTileEntity(i, j, k);
    	if(tile == null || Block.blocksList[tile.oBlockId] == null)
    	{
    		return 1;
    	}
        return Block.blocksList[tile.oBlockId].getBlockTexture(iblockaccess, i, j, k, l);
    }

    // public boolean getIsBlockSolid(IBlockAccess iblockaccess, int i, int j, int k, int l)
    // {
    //     TileEntityBlockColored tile = (TileEntityBlockColored)mod_ColoredBlocks.mcInst.theWorld.getBlockTileEntity(i, j, k);
    //     if(tile == null || Block.blocksList[tile.oBlockId] == null)
    //     {
    //         return super.getIsBlockSolid(iblockaccess, i, j, k, l);
    //     }
    //     return Block.blocksList[tile.oBlockId].getIsBlockSolid(iblockaccess, i, j, k, l);
    // }

    // public AxisAlignedBB getSelectedBoundingBoxFromPool(World world, int i, int j, int k)
    // {
    //     TileEntityBlockColored tile = (TileEntityBlockColored)world.getBlockTileEntity(i, j, k);
    //     if(tile == null || Block.blocksList[tile.oBlockId] == null)
    //     {
    //         return super.getSelectedBoundingBoxFromPool(world, i, j, k);
    //     }
    //     return Block.blocksList[tile.oBlockId].getSelectedBoundingBoxFromPool(world, i, j, k);
    // }

    // public void getCollidingBoundingBoxes(World world, int i, int j, int k, AxisAlignedBB axisalignedbb, ArrayList arraylist)
    // {
    //     TileEntityBlockColored tile = (TileEntityBlockColored)world.getBlockTileEntity(i, j, k);
    //     if(tile == null || Block.blocksList[tile.oBlockId] == null)
    //     {
    //         super.getCollidingBoundingBoxes(world, i, j, k, axisalignedbb, arraylist);
    //         return;
    //     }
    //     Block.blocksList[tile.oBlockId].getCollidingBoundingBoxes(world, i, j, k, axisalignedbb, arraylist);
    // }

    public float blockStrength(World world, EntityPlayer player,
            int i, int j, int k) {
        TileEntityBlockColored tile = (TileEntityBlockColored)world.getBlockTileEntity(i, j, k);
        if(tile == null || Block.blocksList[tile.oBlockId] == null)
        {
            return super.blockStrength(world, player, i, j, k);
        }
        return Block.blocksList[tile.oBlockId].blockStrength(world, player, i, j, k);
    }

    public int getFlammability(IBlockAccess world, int x, int y, int z, int metadata, int face)
    {
        TileEntityBlockColored tile = (TileEntityBlockColored)world.getBlockTileEntity(x, y, z);
        if(tile == null || Block.blocksList[tile.oBlockId] == null)
        {
            return super.getFlammability(world, x, y, z, metadata, face);
        }
        return Block.blocksList[tile.oBlockId].getFlammability(world, x, y, z, metadata, face);
    }

    public int getFireSpreadSpeed(World world, int x, int y, int z, int metadata, int face)
    {
        TileEntityBlockColored tile = (TileEntityBlockColored)world.getBlockTileEntity(x, y, z);
        if(tile == null || Block.blocksList[tile.oBlockId] == null)
        {
            return super.getFireSpreadSpeed(world, x, y, z, metadata, face);
        }
        return Block.blocksList[tile.oBlockId].getFireSpreadSpeed(world, x, y, z, metadata, face);
    }

    public int getLightValue(IBlockAccess iba, int i, int j, int k) {
        TileEntityBlockColored tile = (TileEntityBlockColored)mod_ColoredBlocks.mcInst.theWorld.getBlockTileEntity(i, j, k);
        if(tile == null || Block.blocksList[tile.oBlockId] == null)
        {
            return super.getLightValue(iba, i, j, k);
        }
        return tile.lightvalue;
    }

    public ArrayList<ItemStack> getBlockDropped(World world, int X, int Y, int Z, int metadata, int fortune)
    {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        
        TileEntityBlockColored tile = (TileEntityBlockColored)world.getBlockTileEntity(X, Y, Z);
        if(tile == null)
        {
            return ret;
        }
        boolean flag = false;
        if(Block.blocksList[tile.oBlockId] != null)
        {
            flag = true;
        }

        int count = super.quantityDropped(metadata, fortune, world.rand);
        if(flag)
        {
            count = Block.blocksList[tile.oBlockId].quantityDropped(metadata, fortune, world.rand);
        }
        for(int i = 0; i < count; i++)
        {
            int id = super.idDropped(metadata, world.rand, 0);
            if(flag)
            {
                id = Block.blocksList[tile.oBlockId].idDropped(metadata, world.rand, 0);
            }
            if (id > 0)
            {
                ret.add(new ItemStack(id, 1, damageDropped(metadata)));
            }
        }
        return ret;
    }

    public boolean removeBlockByPlayer(World world, EntityPlayer player,
            int i, int j, int k) {
        TileEntityBlockColored tile = (TileEntityBlockColored)world.getBlockTileEntity(i, j, k);
        if(tile == null)
        {
            return false;
        }
        System.out.print((new StringBuilder()).append("calling").toString());
        player.addStat(StatList.mineBlockStatArray[tile.oBlockId], 1);
        int i1 = EnchantmentHelper.getFortuneModifier(player.inventory);
        int l = world.getBlockMetadata(i, j, k);
        if(Block.blocksList[tile.oBlockId] != null && Block.blocksList[tile.oBlockId].canHarvestBlock(player, l))
        {
            dropBlockAsItem(world, i, j, k, l, i1);
        }
        return world.setBlockWithNotify(i, j, k, 0);
    }
    
    public TileEntity getBlockEntity()
    {
        return new TileEntityBlockColored();
    }

    public boolean isBlockNormalCube(World world, int i, int j, int k) {
        return true;
    }

    protected int damageDropped(int i)
    {
        return i;
    }
}
